function [FPGA, ML] = DataLabeling(dataFPGA, dataML)
try
    %% LL
    FPGA.RightSpringAngle = dataFPGA(1, :);
    FPGA.RightActualTorque = dataFPGA(2, :);
    FPGA.RightDesiredTorque = dataFPGA(3, :);
    FPGA.RightJointAngle = dataFPGA(4, :);
    FPGA.RightSetCurrent = dataFPGA(5, :);
    FPGA.RightMotorCounts = dataFPGA(6, :);

    FPGA.LeftSpringAngle = dataFPGA(7, :);
    FPGA.LeftActualTorque = dataFPGA(8, :);
    FPGA.LeftDesiredTorque = dataFPGA(9, :);
    FPGA.LeftJointAngle = dataFPGA(10, :);
    FPGA.LeftSetCurrent = dataFPGA(11, :);
    FPGA.LeftMotorCounts = dataFPGA(12, :);

    FPGA.Iter = dataFPGA(13,:);
    FPGA.SynchON = dataFPGA(14,:);
    FPGA.AssistON = dataFPGA(15,:);
    FPGA.MissedPeriods = dataFPGA(16,:);
    FPGA.IterDur = dataFPGA(17,:);
    FPGA.EmulatedCounterDiff = dataFPGA(18,:);
catch
    FPGA = [];
end

%% ML
ML.RightSpringAngle = dataML(1, :);
ML.RightActualTorque = dataML(2, :);
ML.RightDesiredTorque = dataML(3, :);
ML.RightJointAngle = dataML(4, :);
ML.RightSetCurrent = dataML(5, :);
ML.RightMotorCounts = dataML(6, :);

ML.LeftSpringAngle = dataML(7, :);
ML.LeftActualTorque = dataML(8, :);
ML.LeftDesiredTorque = dataML(9, :);
ML.LeftJointAngle = dataML(10, :);
ML.LeftSetCurrent = dataML(11, :);
ML.LeftMotorCounts = dataML(12, :);

ML.ContPhse = dataML(13:18,:);
ML.Phase = ML.ContPhse(2,:);

ML.Iter = dataML(19,:);
ML.SynchON = dataML(20,:);
ML.AssistON = dataML(21,:);
ML.MissedPeriods = dataML(22,:);

% ML.IterDur = dataML(23,:);
% ML.Right_TorqueLimit = dataML(24,:);
% ML.Left_AngleLimit = dataML(25,:);
% ML.Left_TorqueLimit = dataML(26,:);
% ML.FFparams = dataML(27:38,:);
try
    ML.EmulatedCounter_Diff = dataML(39,:);
catch
    ML.EmulatedCounter_Diff = zeros(1,length(ML.LeftJointAngle));
end
end